@extends('layouts.master')

@section('content')
@section('title')
@endsection
<style>
    ul li.active,
    a.active {
        color: #3fbbc0;
    }

</style>
<div class="" role="main">
    <div class="">
        <div class="page-title">
            <div class="title_left">
                <h5>{{$header['pageTitle']}} </h5>
            </div>
           
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12 col-sm-12 col-lg-12">
                <div class="x_panel">
                    <div class="x_title" style="border:none;">
                        <h2>{{$header['tableTitle']}} </h2>
                    </div>
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-12 col-md-12 col-lg-12">
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleInputFormDate">Form</label>
                                        <input type="text" class="form-control datepickerMonthYearAppend" id="fromDate" aria-describedby="" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleInputFormDate">To</label>
                                        <input type="text" class="form-control datepickerMonthYearAppend" id="toDate" aria-describedby="" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleFormControlSelectDepartment">Department</label>
                                        <select class="form-control select2" id="departmentId">
                                            <option value="">Select</option>
                                            @foreach($department as $dept)
                                                <option value="{{$dept->LOOKUP_DATA_ID}}">{{$dept->LOOKUP_DATA_NAME}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleFormControlSelectEmployee">Employee</label>
                                        <select class="form-control select2" id="employeeId">
                                            <option value="">Select</option>
                                            @foreach($employee as $emp)
                                                <option value="{{$emp->employee_id}}">{{$emp->employee_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2">
                                    <div class="form-group">
                                        <label for="exampleFormControlStatus">Cagegory</label>
                                        <select class="form-control select2" id="task_category">
                                            <option value="">Select</option>
                                            @foreach($taskCategory as $takCat)
                                            <option value="{{$takCat->lookup_data_id}}">{{$takCat->lookup_data_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-2 col-md-2 col-lg-2" style="margin-top: 3%">
                                    <div class="field item form-group">
                                        <label class="col-form-label col-md-3 col-sm-3  label-align"></label>
                                        <div class="col-md-9 col-sm-9">
                                            <button type="button" id="searchID" class="btn btn-success">Search</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchInfo">
                                    <table id="datatable1" class="table table-striped table-bordered dataTable"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Department</th>
                                                <th>Total Task</th>
                                                <th>Task Category</th>
                                                <th>Pending Task</th>
                                                <th>Complete Task</th>
                                                <th>Factory Visit</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($department as $key=> $dept)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$dept->LOOKUP_DATA_NAME}}</td>
                                                <td>
                                                    @php 
                                                    $formDate = date('Y-m-01');
                                                    $toDate = date('Y-m-t');
                                                    $today = date('Y-m-d');
                                                    $totalTask = DB::selectOne("SELECT count(task_title) TOTAL FROM `npoly_task_report` WHERE department_id = $dept->LOOKUP_DATA_ID  
                                                                    AND task_create_date BETWEEN '$formDate' AND '$toDate'");
                                                    $totalComplete = DB::selectOne("SELECT COUNT(tr.task_id) TOTAL_COMPLETE
                                                        FROM npoly_task_report as tr
                                                        WHERE tr.department_id = $dept->LOOKUP_DATA_ID
                                                        AND tr.task_complete = 100
                                                        AND tr.task_create_date BETWEEN '$formDate' AND '$toDate'"); 

                                                    $totalPending = DB::selectOne("SELECT COUNT(tr.task_id) TOTAL_PENDING
                                                    FROM npoly_task_report as tr
                                                    WHERE tr.department_id = $dept->LOOKUP_DATA_ID
                                                    AND tr.task_complete < 100
                                                    AND tr.task_create_date BETWEEN '$formDate' AND '$toDate'
                                                    AND tr.forecast_date < '$today'");                 
                                                    echo $totalTask->TOTAL;
                                                    $factoryVisit = DB::selectOne("SELECT COUNT(tr.task_id) FACTORY_VISIT
                                                        FROM npoly_task_report as tr
                                                        WHERE tr.department_id = $dept->LOOKUP_DATA_ID
                                                        AND tr.task_category = 267
                                                        AND tr.task_create_date BETWEEN '$formDate' AND '$toDate'");
                                                    @endphp
                                                </td>
                                                <td>
                                                @php 
                                                    $taskCategory = DB::selectOne("SELECT GROUP_CONCAT(DISTINCT lkp.lookup_data_name SEPARATOR ', ') AS task_category
                                                                    FROM npoly_task_report as tr,sa_lookup_data as lkp
                                                                    WHERE tr.task_category = lkp.lookup_data_id
                                                                    AND tr.department_id = $dept->LOOKUP_DATA_ID
                                                                    AND tr.task_create_date BETWEEN '$formDate' AND '$toDate'");
                                                    echo $taskCategory->task_category;
                                                    @endphp
                                                </td>
                                                <td>
                                                @php 
                                                    
                                                   echo  $totalPending->TOTAL_PENDING;
                                                    @endphp
                                                </td>
                                                <td>
                                                    @php 
                                                   
                                                    echo $totalComplete->TOTAL_COMPLETE;
                                                    @endphp
                                                </td>
                                                <td>
                                                    {{$factoryVisit->FACTORY_VISIT}}
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="margin-top:25px !important">
                            <div class="col-sm-12">
                                <div class="card-box table-responsive searchInfo">
                                    <table id="datatable" class="table table-striped table-bordered dataTable table2excel"
                                        role="grid" aria-describedby="data-table-info" width="100%">
                                        <thead style="background-color: #0b58a2; color: white">
                                            <tr>
                                                <th>Sl</th>
                                                <th>Employee</th>
                                                <th>Total Task</th>
                                                <th>Task Category</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($employee as $key=> $emp)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$emp->employee_name}}</td>
                                                <td>
                                                @php 
                                                    $formDate = date('Y-m-01');
                                                    $toDate = date('Y-m-t');
                                                    $today = date('Y-m-d');
                                                    $totalTask = DB::selectOne("SELECT count(task_title) TOTAL FROM `npoly_task_report` WHERE employee_id = $emp->employee_id  
                                                                    AND task_create_date BETWEEN '$formDate' AND '$toDate'");
                                                   
                                                    @endphp
                                                    {{$totalTask->TOTAL}}
                                                    
                                                </td>
                                                <td>
                                                @php 
                                                    $taskCategory = DB::selectOne("SELECT GROUP_CONCAT(DISTINCT lkp.lookup_data_name SEPARATOR ', ') AS task_category
                                                                    FROM npoly_task_report as tr,sa_lookup_data as lkp
                                                                    WHERE tr.task_category = lkp.lookup_data_id
                                                                    AND tr.employee_id = $emp->employee_id
                                                                    AND tr.task_create_date BETWEEN '$formDate' AND '$toDate'");
                                                    echo $taskCategory->task_category;
                                                    @endphp
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
 
    $(document).ready(function() {
    var logoDir = '';
    var orgName ='';
    var tableName = $('.table').attr('title');
    $('.dataTable').dataTable( {
        dom: 'Blfrtip',
        buttons: [
            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Print',
                title: '',
                messageTop: tableName,
                className: 'btn btn-sm btn-outline btn-success',
                exportOptions: {
                    columns: ':visible',

                },
                customize: function ( win ) {
                    $(win.document.body)
                        .css( 'font-size', '12pt' )
                },
                footer: true,
                autoPrint: true,

            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o"></i> Pdf',
                className: 'btn btn-sm btn-outline btn-danger',
                title: $('h1').text(),
                exportOptions: {
                    columns: ':visible',
                } ,
                footer: true
            },
            
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel-o"></i> Excel',
                className: 'btn btn-sm btn-outline btn-warning',
                title: $('h1').text(),
                exportOptions: {
                    columns: ':visible',
                } ,
                footer: true
            },
            // {
            //     extend: 'csv',
            //     text: '<i class="fa fa-file"></i> Csv',
            //     className: 'btn btn-sm btn-outline btn-info',
            //     title: $('h1').text(),
            //     exportOptions: {
            //         columns: ':visible',
            //     } ,
            //     footer: true
            // },
            // {
            //     extend: 'colvis',
            //     text: '<i class="fa fa-eye"></i> Visible',
            //     title: $('h1').text(),
            //     className: 'btn btn-sm btn-outline btn-success',
            //     exportOptions: {
            //         columns: ':visible',
            //     },
            //     footer: true,
            //     autoPrint: true,
            // },
        ],
    });
    $('.select2').select2();
} );


    $('#departmentId').change(function(){
        var deptId = $(this).val();
        $('#employeeId').html('<option value="">--select--</option>');
        if(deptId!=''){
            $.ajax({
                type: 'GET',
                url: '{{url("/getEmployee")}}/'+deptId,
                success: function (data) {
                    $('#employeeId').html(data);
                }
            });
        }
    });

    $('#searchID').click(function (){
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var deptId = $('#departmentId').val();
        var empId = $('#employeeId').val();
        var taskCategory = $('#task_category').val();

        if(fromDate ==""){
            alert('Please Select Form Date');
        }else if(toDate ==""){
            alert('Please Select To Date');
        }else{
            var _token = '{{csrf_token()}}'
            $.ajax({
                type: 'GET',
                url: '{{url("/month_wise_task_report")}}',
                data: { fromDate: fromDate,toDate:toDate,deptId:deptId,empId:empId,taskCategory:taskCategory},
                success: function (data) {
                    $('.searchInfo').html(data);
                    $("#datatable").dataTable({
                        // ... skipped ...
                    });
                }
            });
        }
    })   
</script>

@endsection
